/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.eventmon;

import com.ibm.hwmca.base.eventmon.EventMonitorErrorIds;
import com.ibm.hwmca.base.saverest.CustomizableData;
import com.ibm.hwmca.base.saverest.DataRepApp;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.eventmon.DelayQueue;
import com.ibm.hwmca.fw.eventmon.DelayQueueListener;
import com.ibm.hwmca.fw.eventmon.EventDefinition;
import com.ibm.hwmca.fw.eventmon.EventMonitor;
import com.ibm.hwmca.fw.eventmon.EventMonitorConstants;
import com.ibm.hwmca.fw.eventmon.EventMonitorListener;
import com.ibm.hwmca.fw.eventmon.MonitoredEvent;
import com.ibm.hwmca.fw.eventmon.PersistentEventMonitorData;
import com.ibm.hwmca.fw.eventmon.TestEvent;
import com.ibm.hwmca.fw.eventmon.email.Emailer;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.LogAttributes;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class EventMonitorManager
implements Serializable,
EventMonitorListener,
DelayQueueListener,
EventMonitorConstants,
EventMonitorErrorIds {
    static final long serialVersionUID = -5618736444376981950L;
    private static final String TRACE_MASKT = "XLISTENT";
    private static final String TRACE_MASKF = "XLISTENF";
    private static final String TRACE_MASKD = "XLISTEND";
    private static final String THIS_CLASS = "EventMonitorManager";
    private static boolean retrievingPersistentInstance = false;
    private static EventMonitorManager MANAGER = null;
    private static DataRepApp dataRepApp = DataRepApp.getDataRepApp();
    private static String customDataKey = new EventMonitorCustomizableData().getCustomDataKey();
    private String _smtpHost = "";
    private int _smtpPort = 25;
    private int _minSecondsBetweenEmails = 300;
    private Map _eventMonitors;
    private transient Map _emailQueues;
    private int _nameCounter = 0;
    private transient EventDefinition[] _events;
    private transient PropertyChangeSupport _pcPropertySupport = new PropertyChangeSupport(this);
    private transient VetoableChangeSupport _pcVetoableSupport = new VetoableChangeSupport(this);

    public static void logException(short errorId, Throwable exception) {
        Trace.trace(TRACE_MASKF, "EventMonitorManager.logException:  logging an exception");
        new FrameworkLog(EventMonitorErrorIds.CLASS_LOG_INFO, errorId, exception).log(LogAttributes.INFO_LOG);
    }

    public static EventMonitorManager getManager() {
        if (MANAGER == null) {
            try {
                if (!retrievingPersistentInstance && MANAGER == null) {
                    retrievingPersistentInstance = true;
                    MANAGER = EventMonitorManager.retrieveData();
                    retrievingPersistentInstance = false;
                    MANAGER.start();
                }
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "getManager:  exception retrieving persistent data");
                Trace.trace(TRACE_MASKF, e);
            }
        }
        if (MANAGER == null) {
            Trace.trace(TRACE_MASKF, "getManager:  creating new manager");
            MANAGER = new EventMonitorManager();
        }
        return MANAGER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static EventMonitorManager retrieveData() throws IOException, ClassNotFoundException {
        PersistenceManager pMgr = PersistenceManager.getPersistenceManager();
        PersistentEventMonitorData pnd = null;
        if (pMgr.contains("com.ibm.hwmca.fw.eventmon.EventMonitorDataKey")) {
            Trace.trace(TRACE_MASKF, "Have persistent data, reading it in");
            try {
                try {
                    pnd = (PersistentEventMonitorData)pMgr.read("com.ibm.hwmca.fw.eventmon.EventMonitorDataKey");
                }
                catch (PersistenceException e) {
                    Trace.trace(TRACE_MASKF, e);
                    EventMonitorManager.logException((short)1, new HException(e));
                    Object var4_3 = null;
                    if (pnd != null) return pnd.getEventMonitorManager();
                    Trace.trace(TRACE_MASKF, "error reading in persistent version, recreating");
                    pnd = new PersistentEventMonitorData();
                    return pnd.getEventMonitorManager();
                }
                Object var4_2 = null;
                if (pnd != null) return pnd.getEventMonitorManager();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (pnd != null) throw throwable;
                Trace.trace(TRACE_MASKF, "error reading in persistent version, recreating");
                pnd = new PersistentEventMonitorData();
                throw throwable;
            }
            Trace.trace(TRACE_MASKF, "error reading in persistent version, recreating");
            pnd = new PersistentEventMonitorData();
            return pnd.getEventMonitorManager();
        }
        Trace.trace(TRACE_MASKF, "no persistent version available, making a fresh one");
        pnd = new PersistentEventMonitorData();
        try {
            pMgr.write("com.ibm.hwmca.fw.eventmon.EventMonitorDataKey", pnd);
            return pnd.getEventMonitorManager();
        }
        catch (PersistenceException e) {
            Trace.trace(TRACE_MASKF, e);
            EventMonitorManager.logException((short)2, new HException(e));
            return pnd.getEventMonitorManager();
        }
    }

    public static void saveData() throws IOException {
        Trace.trace(TRACE_MASKT, "-> saveData()");
        PersistenceManager pMgr = PersistenceManager.getPersistenceManager();
        try {
            pMgr.write("com.ibm.hwmca.fw.eventmon.EventMonitorDataKey", new PersistentEventMonitorData());
        }
        catch (PersistenceException e) {
            Trace.trace(TRACE_MASKF, e);
            EventMonitorManager.logException((short)2, new HException(e));
        }
        if (dataRepApp.isDataRepEnabled()) {
            dataRepApp.updateCustomDataLevel(customDataKey);
        }
        Trace.trace(TRACE_MASKT, "<- saveData");
    }

    private EventMonitorManager() {
        this._eventMonitors = new HashMap();
        this._emailQueues = new HashMap();
        EventMonitor[] exampleMonitors = null;
        int i = 0;
        while (i < this.getEventDefinitions().length) {
            exampleMonitors = this.getEventDefinitions()[i].getExampleEventMonitors();
            if (exampleMonitors != null) {
                int j = 0;
                while (j < exampleMonitors.length) {
                    try {
                        this.addEventMonitor(exampleMonitors[j]);
                    }
                    catch (IllegalArgumentException e) {
                        // empty catch block
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    void fireVetoableChange(PropertyChangeEvent event) throws PropertyVetoException {
        this._pcVetoableSupport.fireVetoableChange(event);
    }

    private void restoreTransients() {
        this._emailQueues = new HashMap();
        this._pcPropertySupport = new PropertyChangeSupport(this);
        this._pcVetoableSupport = new VetoableChangeSupport(this);
    }

    private void start() {
        this.restoreTransients();
        Iterator i = this._eventMonitors.values().iterator();
        EventMonitor monitor = null;
        while (i.hasNext()) {
            monitor = (EventMonitor)i.next();
            monitor.addListener(this);
            try {
                monitor.startListening();
            }
            catch (Exception e) {
                EventMonitorManager.logException((short)14, e);
            }
        }
    }

    private void stop() {
        Iterator i = this._eventMonitors.values().iterator();
        EventMonitor monitor = null;
        while (i.hasNext()) {
            monitor = (EventMonitor)i.next();
            monitor.removeListener(this);
            try {
                monitor.stopListening();
            }
            catch (Exception e) {
                EventMonitorManager.logException((short)15, e);
            }
        }
    }

    public EventDefinition[] getEventDefinitions() {
        block2: {
            if (this._events != null) break block2;
            try {
                Class<?> hwClass = Class.forName("com.ibm.hwmca.z.eventmon.HWMessageDefinition");
                Class<?> osClass = Class.forName("com.ibm.hwmca.z.eventmon.OSMessageDefinition");
                Class<?> scClass = Class.forName("com.ibm.hwmca.z.eventmon.StateChangeDefinition");
                EventDefinition[] newEvents = new EventDefinition[]{(EventDefinition)hwClass.newInstance(), (EventDefinition)osClass.newInstance(), (EventDefinition)scClass.newInstance()};
                this._events = newEvents;
            }
            catch (Exception e) {
                EventDefinition[] newEvents = new EventDefinition[]{};
                this._events = newEvents;
                Trace.trace(TRACE_MASKD, "EventMonitorManager.getEventDefinitions:  failed to create event definitions", e);
                EventMonitorManager.logException((short)4, new HException(e));
            }
        }
        return this._events;
    }

    public String getSmtpHost() {
        return this._smtpHost;
    }

    public void setSmtpHost(String host) {
        this._smtpHost = host;
    }

    public int getSmtpPort() {
        return this._smtpPort;
    }

    public void setSmtpPort(int port) {
        this._smtpPort = port;
    }

    public int getMinimumTimeBetweenEmailSeconds() {
        return this._minSecondsBetweenEmails;
    }

    public void setMinimumTimeBetweenEmailSeconds(int secs) {
        this._minSecondsBetweenEmails = secs;
    }

    public String[] getEmailStrings() {
        TreeSet<String> ts = new TreeSet<String>();
        Iterator<Object> i = this._eventMonitors.values().iterator();
        while (i.hasNext()) {
            ts.add(((EventMonitor)i.next()).getEmailTargets());
        }
        String[] emailStrings = new String[ts.size()];
        i = ts.iterator();
        int count = 0;
        while (i.hasNext()) {
            String email = (String)i.next();
            emailStrings[count++] = email;
        }
        return emailStrings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void editEventMonitor(EventMonitor editedMonitor) {
        Trace.trace(TRACE_MASKF, "--> EventMonitorManager.editEventMonitor:  ");
        EventMonitor existingMonitor = null;
        Map map = this._eventMonitors;
        synchronized (map) {
            existingMonitor = this.getEventMonitor(editedMonitor.getName());
            if (existingMonitor == null) {
                throw new IllegalArgumentException();
            }
            existingMonitor.setEnabled(false);
            this.removeEventMonitor(existingMonitor.getName());
            Trace.trace(TRACE_MASKF, "EventMonitorManager.editEventMonitor:  removed existing monitor " + existingMonitor);
            this.addEventMonitor(editedMonitor);
            Trace.trace(TRACE_MASKF, "EventMonitorManager.editEventMonitor:  added edited monitor " + editedMonitor);
        }
        this._pcPropertySupport.firePropertyChange(new PropertyChangeEvent(this, "edit", existingMonitor, editedMonitor));
        Trace.trace(TRACE_MASKF, "<-- EventMonitorManager.editEventMonitor:  ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean monitorExists(String name) {
        Map map = this._eventMonitors;
        synchronized (map) {
            return this._eventMonitors.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventMonitor(EventMonitor monitor) {
        Map map = this._eventMonitors;
        synchronized (map) {
            if (this.monitorExists(monitor.getName())) {
                throw new IllegalArgumentException();
            }
            this._eventMonitors.put(monitor.getName(), monitor);
        }
        monitor.addListener(this);
        this._pcPropertySupport.firePropertyChange(new PropertyChangeEvent(this, "add", null, monitor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventMonitor(String name) {
        EventMonitor monitor = null;
        Map map = this._eventMonitors;
        synchronized (map) {
            monitor = (EventMonitor)this._eventMonitors.remove(name);
        }
        if (monitor != null) {
            monitor.setEnabled(false);
            monitor.removeListener(this);
        }
        this._pcPropertySupport.firePropertyChange(new PropertyChangeEvent(this, "remove", monitor, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventMonitor getEventMonitor(String name) {
        Map map = this._eventMonitors;
        synchronized (map) {
            return (EventMonitor)this._eventMonitors.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getEventMonitors() {
        Map map = this._eventMonitors;
        synchronized (map) {
            return (Map)((HashMap)this._eventMonitors).clone();
        }
    }

    public boolean isSmtpServerReachable() {
        boolean result;
        try {
            new Emailer(this.getSmtpHost(), this.getSmtpPort());
            result = true;
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public void writeToEvent(MonitoredEvent event, String text) {
        Trace.trace(TRACE_MASKF, "EventMonitorManager.writeToEvent:  text:  " + text);
        if (event.isLogging()) {
            event.log(text);
            event.log("\n");
        }
    }

    public void fireTestEvent(TestEvent event, Locale locale) {
        ResourceBundle resources = ResourceBundle.getBundle("com/ibm/hwmca/base/res/text", locale);
        this.writeToEvent(event, resources.getString("eventmon.starting.test.colon") + "  " + event);
        int count = 0;
        Iterator monitors = this.getEventMonitors().values().iterator();
        EventMonitor monitor = null;
        while (monitors.hasNext()) {
            monitor = (EventMonitor)monitors.next();
            if (!monitor.getItemNameInUI().equals(event.getType()) || !monitor.getObjectsToMonitor().contains(event.getSourceId())) continue;
            this.writeToEvent(event, "     " + resources.getString("eventmon.testing.monitor.colon") + "  " + monitor.getName());
            monitor.handleEvent(event);
            ++count;
        }
        this.writeToEvent(event, resources.getString("eventmon.finished.testing"));
        this.writeToEvent(event, resources.getString("eventmon.count.tested.colon") + "  " + count);
    }

    public void handleEvent(MonitoredEvent event, EventMonitor monitor) {
        Trace.trace(TRACE_MASKF, "--> EventMonitorManager.handleEvent:  " + event);
        ResourceBundle resources = ResourceBundle.getBundle("com/ibm/hwmca/base/res/text", monitor.getLocale());
        String message = this.getEmailText(event, monitor);
        Trace.trace(TRACE_MASKF, "EventMonitorManager.handleEvent:  message is " + message);
        String emailTargets = monitor.getEmailTargets() + "#";
        emailTargets = emailTargets.substring(0, emailTargets.indexOf("#"));
        StringTokenizer addressList = new StringTokenizer(emailTargets, " ,");
        while (addressList.hasMoreTokens()) {
            String emailAddress = addressList.nextToken();
            this.writeToEvent(event, "     " + resources.getString("eventmon.sending.email.colon") + "  " + emailAddress);
            this.queueEmails(emailAddress, message);
            Trace.trace(TRACE_MASKF, "EventMonitorManager.handleEvent:  queued email to " + emailAddress);
        }
        Trace.trace(TRACE_MASKF, "<-- EventMonitorManager.handleEvent:  ");
    }

    public void queueEmails(String emailAddress, String message) {
        Trace.trace(TRACE_MASKF, "--> EventMonitorManager.queueEmails:  ");
        DelayQueue q = (DelayQueue)this._emailQueues.get(emailAddress);
        if (q == null) {
            q = new DelayQueue(this.getMinimumTimeBetweenEmailSeconds(), emailAddress);
            this._emailQueues.put(emailAddress, q);
            q.addListener(this);
        }
        q.push(message);
        Trace.trace(TRACE_MASKF, "<-- EventMonitorManager.queueEmails:  ");
    }

    public void handleWorkList(List emailMessages, DelayQueue queue) {
        Trace.trace(TRACE_MASKF, "--> EventMonitorManager.handleWorkList:  ");
        if (emailMessages == null || emailMessages.size() == 0) {
            this._emailQueues.remove(queue);
        } else {
            this.sendEmails(emailMessages, queue);
        }
        Trace.trace(TRACE_MASKF, "<-- EventMonitorManager.handleWorkList:  ");
    }

    public void sendEmails(List emailMessages, DelayQueue queue) {
        Trace.trace(TRACE_MASKF, "--> EventMonitorManager.sendEmails:  ");
        StringBuffer messages = new StringBuffer();
        int messageCount = 1;
        Iterator i = emailMessages.iterator();
        while (i.hasNext()) {
            messages.append(this.getEmailSeparator(messageCount++));
            messages.append("\n");
            messages.append((String)i.next());
        }
        try {
            Emailer postman = new Emailer(this.getSmtpHost(), this.getSmtpPort());
            postman.send(queue.getName(), this.getEmailFromField(), this.getEmailSubjectField(messageCount - 1), messages.toString());
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "EventMonitorManager.sendEmails:  got an email exception ", e);
            EventMonitorManager.logException((short)5, e);
        }
        Trace.trace(TRACE_MASKF, "<-- EventMonitorManager.sendEmails:  ");
    }

    private String getEmailSeparator(int messageNumber) {
        return EventMonitorConstants.DEFAULT_RESOURCES.getString("eventmon.msgnum.colon") + "  " + messageNumber + "  **********************************************";
    }

    private String getEmailFromField() {
        String from = null;
        try {
            from = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            from = "EventMonitor";
        }
        return from;
    }

    private String getEmailSubjectField(int messageCount) {
        return EventMonitorConstants.DEFAULT_RESOURCES.getString("eventmon.email.subject") + messageCount;
    }

    private String getEmailText(MonitoredEvent event, EventMonitor monitor) {
        Locale locale = monitor.getLocale();
        ResourceBundle resources = ResourceBundle.getBundle("com/ibm/hwmca/base/res/text", locale);
        StringBuffer msg = new StringBuffer();
        msg.append("     ");
        msg.append(resources.getString("eventmon.event.colon"));
        msg.append("  '");
        msg.append(event.getEventName());
        msg.append("'\n");
        msg.append("          ");
        msg.append(resources.getString("eventmon.source.colon"));
        msg.append("  '");
        msg.append(event.getSourceName(locale));
        msg.append("'\n");
        msg.append("          ");
        msg.append(resources.getString("eventmon.text.colon"));
        msg.append("  '");
        msg.append(event.getText());
        msg.append("'\n");
        String when = DateFormat.getDateTimeInstance(2, 2, monitor.getLocale()).format(event.getWhen().getTime());
        msg.append("          ");
        msg.append(resources.getString("eventmon.time.colon"));
        msg.append("  '");
        msg.append(when);
        msg.append("'\n");
        msg.append("     ");
        msg.append(resources.getString("eventmon.monitor.colon"));
        msg.append("\n");
        msg.append(monitor.stateString("          "));
        msg.append("\n\n");
        return msg.toString();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._pcPropertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._pcPropertySupport.removePropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this._pcVetoableSupport.addVetoableChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this._pcVetoableSupport.removeVetoableChangeListener(listener);
    }

    public static class EventMonitorCustomizableData
    implements CustomizableData {
        public UIInfo getUIInfo() {
            LocalizableText title = new LocalizableText(EventMonitorConstants.DEFAULT_RESOURCES.getString("eventmon.monitor.data"));
            LocalizableText caption = new LocalizableText(EventMonitorConstants.DEFAULT_RESOURCES.getString("eventmon.monitor.all.data"));
            return new UIInfo(title, caption);
        }

        public Serializable getSaveableData() {
            return EventMonitorManager.getManager();
        }

        public void restoreData(Serializable obj) {
            if (MANAGER != null) {
                try {
                    MANAGER.fireVetoableChange(new PropertyChangeEvent(MANAGER, "managerRestore", MANAGER, obj));
                }
                catch (PropertyVetoException e) {
                    Trace.trace(EventMonitorManager.TRACE_MASKD, "EventMonitorManager.restoreData:  restore vetoed", e);
                    EventMonitorManager.logException((short)3, e);
                    return;
                }
                MANAGER.stop();
            }
            MANAGER = (EventMonitorManager)obj;
            MANAGER.start();
        }

        public String getCustomDataKey() {
            return "com.ibm.hwmca.fw.eventmon.EventMonitorManager";
        }
    }
}

